import MaterialEditorCtrl from "./controllers/MaterialEditorCtrl.js";
import MaterialListCtrl from "./controllers/MaterialListCtrl.js";
import MaterialEditorService from "./services/MaterialEditorService.js";

const modulename = "materialeditor";
const partialsDir = 'partials/';

const ngModule = angular.module(modulename, ["ui.router"]);

ngModule.config(['$urlRouterProvider','$stateProvider', function($urlRouterProvider, $stateProvider) {
    $urlRouterProvider.otherwise(($injector) => $injector.get('$state').go('materiallist'));

    $stateProvider
        .state("materiallist", {
            url: "/",
            resolve: MaterialListCtrl.resolve,
            controller: "MaterialListCtrl as matCtrl",
            templateUrl: partialsDir + "materiallist.html"
        })
        .state("materialeditor", {
            url: "/mat/{materialId}",
            resolve: MaterialEditorCtrl.resolve,
            controller: "MaterialEditorCtrl as matCtrl",
            templateUrl: partialsDir + "materialeditor.html"
        })
}]);

ngModule.service("materialEditorService", MaterialEditorService);
ngModule.controller("MaterialEditorCtrl", MaterialEditorCtrl);
ngModule.controller("MaterialListCtrl", MaterialListCtrl);

ngModule.directive("fileHook", function () {
    return {
        link: function (scope, element, attrs) {
            element.bind('change', function(e) {
                scope.value = this.value;
                scope.event = e;
                scope.$eval(attrs.fileHook).then( function() {
                    scope.$apply();
                });
            });
        }
    }
}).directive("tabInit", function () {
    return {
        link: function (scope, element, attrs) {
            scope.CurrentTab = 0
        }
    }
});

angular.bootstrap(document, [modulename]);
