angular.module('rf2.class-position-badge', []).component('classPositionBadge', {
	bindings: {
		entry: '<',
		dynamicVehicleClassColors: '<',
		isMulticlassMode: '<'
	},
	templateUrl: 'src/components/class-position-badge/class-position-badge.component.html',
	controller: function () {
		this.carClassPropName = 'carClass';

		this.getVehicleClassColor = (entry) => {
			let customCssProp = '--cell-bg-color: transparent';

			if (!entry) {
				return customCssProp;
			}

			if (entry.vehicleClassColor) {
				customCssProp = '--cell-bg-color: ' + entry.vehicleClassColor;
			} else if (this.dynamicVehicleClassColors) {
				const dynamicColor = _.find(
					this.dynamicVehicleClassColors,
					{ vehicleClass: entry[this.carClassPropName] }
				);

				if (dynamicColor) {
					customCssProp = `--cell-bg-color: ${dynamicColor.background}; --cell-text-color: ${dynamicColor.text}`;
				}
			}

			return customCssProp;
		}

		this.formatCarClassName = (name) => {
			if (!name) {
				return '-';
			}

			let formattedName = '';

			if (name.indexOf('_') === -1) {
				formattedName = name;
			} else {
				formattedName = name.split('_').join(' ');
			}

			const spacedParts = formattedName.split(' ');

			if (spacedParts.length > 1) {
				formattedName = `${spacedParts[0]} ${spacedParts[1]}`;
			}

			return formattedName;
		}

		this.formatBadgeText = () => {
			let text = '';

			if (!this.isMulticlassMode) {
				text += `${this.entry?.classPosition || ''} - `;
			}

			return text + this.formatCarClassName(this.entry[this.carClassPropName]);
		}
	}
});
