angular.module('entryNameField', [
    'BroadcastService',
    'StandingsService',
    'VehicleInfoService'
]).component('entryNameField', {
    bindings: {
        entry: '<',
        selectedNameType: '<',
        driverNameTypeId: '<?'
    },
    templateUrl: 'src/components/entrynamefield/entrynamefield.html',
    controller: function(broadcastService, standingsService, vehicleInfoService, $scope) {
        var ctrl = this;
        this.entryName = null;

        $scope.$watch(angular.bind(this, function() {
            return ctrl.entry;
        }), function(newVal) {
            ctrl.entryName = getEntryName(newVal);
        });

        $scope.$watch(angular.bind(this, function() {
            return this.selectedNameType;
        }), function() {
            ctrl.entryName = getEntryName(ctrl.entry);
        });

        function getEntryName(entry) {
            if (!entry) {
                return '';
            }

            var entryName = '';
            if (ctrl.selectedNameType === 'Driver') {
                entryName = getDriverName(entry);
            } else if (ctrl.selectedNameType === 'Team') {
                entryName = vehicleInfoService.getTeamNameOverride(entry);
            } else if (ctrl.selectedNameType === 'Vehicle') {
                entryName = vehicleInfoService.getVehicleName(entry);
            }

            return entryName;
        }

        function getDriverName(entry) {
            var driverName = vehicleInfoService.getDriverNameOverride(entry);

            if (ctrl.driverNameTypeId) {
                var lastName = vehicleInfoService.getDriverLastName(driverName)

                switch (ctrl.driverNameTypeId) {
                    case "lastName":
                        driverName = lastName || driverName;
                        break;
                    case "firstName":
                        const firstName = vehicleInfoService.getDriverFirstName(driverName);
                        driverName = firstName || driverName;
                        break;
                    case "initialAndLastName":
                        if (driverName.indexOf(' ') > 0) {
                            driverName = driverName[0] + '. ' + lastName;
                        }
                        break;
                    case "threeLetters":
                        if (lastName.indexOf(' ') > 0) {
                            // If last name has spaces, take three letters from the last part, otherwise everyone from
                            // the Netherlands will be VAN.
                            driverName = lastName.substr(lastName.lastIndexOf(' ') + 1, 3);
                        } else {
                            driverName = lastName.substr(0, 3);
                        }
                        break;
                    default:
                        // Default to full name.
                        break;
                }
            }

            return driverName;
        }
    }
});
