angular.module('overlay.extendedBattleBox', []).component('extendedBattleBoxOverlay', {
    bindings: {
        overlayInfo: '<',
        selectedDriver: '<',
        config: '<',
        customConfig: '<',
        standings: '<',
        sessionInfo: '<',
        entryDataField: '<',
        selectedCarClass: '<',
        selectedNameType: '<',
        driverNameTypeId: '<',
        cars: '<'
    },
    templateUrl: 'src/components/extendedbattleboxoverlay/extendedbattlebox.overlay.html',
    controller: function(broadcastService, sessionService, standingsService, utilService, $timeout) {
        var ctrl = this;
        this.displayedDrivers = []; // Drivers displayed in the overlay
        this.updateListTimeout = null;
        this.updateListDelay = 5000;

        // Defaults, overridden by custom config value if available:
        this.listMaxDrivers = 5;
        this.listMaxGap = 2;

        this.$onChanges = function(changes) {
            if (changes.selectedDriver) {
                var newDriver = changes.selectedDriver.currentValue;
                var oldDriver = changes.selectedDriver.previousValue;

                if (newDriver && oldDriver && newDriver.slotID !== oldDriver.slotID) {
                    // Driver changed, update driver list immediately by cancelling the timeout.
                    $timeout.cancel(ctrl.updateListTimeout);
                    ctrl.updateListTimeout = null;
                }
            }

            if (changes.customConfig) {
                var maxDriverCount = _.get(
                    changes,
                    'customConfig.currentValue.overlays.extendedBattleBox.maxDriverCount'
                );

                if (maxDriverCount > 0) {
                    ctrl.listMaxDrivers = maxDriverCount;
                }

                var maxGap = _.get(changes, 'customConfig.currentValue.overlays.extendedBattleBox.maxGap');
                if (maxGap > 0) {
                    ctrl.listMaxGap = maxGap;
                }
            }

            if (changes.standings && changes.standings.currentValue && changes.standings.currentValue[0]) {
                if (ctrl.selectedDriver) {
                    if (ctrl.updateListTimeout) {
                        return;
                    }

                    ctrl.displayedDrivers = [];
                    updateDriverList(ctrl.selectedDriver);
                    animatePositionChange(changes.standings.currentValue, changes.standings.previousValue);
                    ctrl.updateListTimeout = $timeout(function() {
                        ctrl.updateListTimeout = null;
                    }, ctrl.updateListDelay);
                }
            }
        }

        function updateDriverList(selectedDriver) {
            if (ctrl.displayedDrivers.length > 0) {
                return;
            }

            ctrl.displayedDrivers.push(selectedDriver);
            addDrivers(selectedDriver);
        }

        function addDrivers(selectedDriver) {
            // Check and add drivers ahead
            for (var i = 0; i < ctrl.listMaxDrivers - 1; i++) {
                var comparedPosition = broadcastService.isMixedClassMode(ctrl.selectedCarClass)
                    ? selectedDriver.position - i
                    : selectedDriver.classPosition - i;

                var comparedDriver;
                var driverToBeAdded;
                if (broadcastService.isMixedClassMode(ctrl.selectedCarClass)) {
                    comparedDriver = _.find(ctrl.standings, { position: comparedPosition });
                    driverToBeAdded = _.find(ctrl.standings, { position: comparedPosition - 1 });
                } else {
                    comparedDriver = _.find(ctrl.standings, {
                        carClass: selectedDriver.carClass,
                        classPosition: comparedPosition
                    });

                    driverToBeAdded = _.find(ctrl.standings, {
                        carClass: selectedDriver.carClass,
                        classPosition: comparedPosition - 1
                    });
                }

                var isRaceSession = sessionService.isRaceSession(ctrl.sessionInfo);
                if (!checkAddDriver(true, comparedDriver, driverToBeAdded, !isRaceSession)) {
                    break;
                }
            }

            // Check and add drivers behind
            for (var i = 0; i < ctrl.listMaxDrivers - 1; i++) {
                var comparedPosition = broadcastService.isMixedClassMode(ctrl.selectedCarClass)
                    ? selectedDriver.position + (i + 1)
                    : selectedDriver.classPosition + (i + 1)

                var comparedDriver;
                var driverToBeAdded;
                if (broadcastService.isMixedClassMode(ctrl.selectedCarClass)) {
                    comparedDriver = _.find(ctrl.standings, { position: comparedPosition });
                } else {
                    comparedDriver = _.find(ctrl.standings, {
                        carClass: selectedDriver.carClass,
                        classPosition: comparedPosition
                    });
                }

                driverToBeAdded = comparedDriver;
                var isRaceSession = sessionService.isRaceSession(ctrl.sessionInfo);
                if (!checkAddDriver(false, comparedDriver, driverToBeAdded, !isRaceSession)) {
                    break;
                }
            }
        }

        function checkAddDriver(addAhead, compareDriver, driverToBeAdded, skipComparison) {
            if (ctrl.displayedDrivers.length === ctrl.listMaxDrivers || !compareDriver || !driverToBeAdded) {
                return false;
            }

            var timeDiff;
            if (broadcastService.isMixedClassMode(ctrl.selectedCarClass)) {
                timeDiff = Math.abs(compareDriver.timeBehindNext);
            } else {
                timeDiff = Math.abs(compareDriver.timeBehindNextInClass);
            }

            if (skipComparison || (timeDiff > 0 && timeDiff < ctrl.listMaxGap)) {
                if (!_.find(ctrl.displayedDrivers, { slotID: driverToBeAdded.slotID })) {
                    if (addAhead) {
                        ctrl.displayedDrivers.unshift(driverToBeAdded);
                    } else {
                        ctrl.displayedDrivers.push(driverToBeAdded);
                    }

                    return true;
                }
            }

            return false;
        }

        this.getRowClass = function(entry, first, index) {
            return {
                ['slot-' + entry.slotID]: entry && entry.slotID > -1,
                first: first,
                'entry-faded-out': standingsService.getEntryFadedOut(entry),
                'last-fixed-row': _.get(ctrl, 'config.scrollingListConfig.topRowCount') === index + 1,
                'selected-driver': _.get(ctrl, 'selectedDriver.slotID') === entry.slotID,
                'has-drs-active': standingsService.hasDrsActive(entry)
            }
        }

        this.getCssCarClassName = function() {
            return utilService.generateCssCarClassName(_.get(ctrl, 'selectedDriver.carClass'));
        }

        this.getBorderLeftStyle = function() {
            return broadcastService.getDriverBorderStyle(ctrl.selectedDriver, ctrl.customConfig, 'borderLeft');
        }

        this.getBattleLeaderPosition = function() {
            if (broadcastService.isMixedClassMode(ctrl.selectedCarClass)) {
                return _.get(ctrl, 'displayedDrivers.0.position');
            }

            return _.get(ctrl, 'displayedDrivers.0.classPosition');
        }

        ctrl.getPittingStatus = function(driver) {
            return standingsService.isDriverPitting(driver);
        }

        ctrl.getRedStatus = function(driver) {
            return standingsService.isDriverDnf(driver) || standingsService.isDriverDq(driver);
        }

        this.displayDynamicValue = function(entry, index) {
            if (!entry) {
                return '';
            }

            if (index === 0) {
                return 'Int';
            }

            if (sessionService.isRaceSession(ctrl.sessionInfo)) {
                return standingsService.displayLiveGapToNextDriver(
                    entry,
                    !broadcastService.isMixedClassMode(ctrl.selectedCarClass)
                );
            } else {
                var battleLeader = ctrl.displayedDrivers[0];
                if (!battleLeader
                    || !standingsService.isDriverLapTimeValid(entry, 'bestLapTime')
                    || !standingsService.isDriverLapTimeValid(battleLeader, 'bestLapTime')
                ) {
                    return '-';
                }

                return standingsService.formatLapTimeDiff(entry.bestLapTime - battleLeader.bestLapTime);
            }
        }

        function animatePositionChange(newVal, oldVal) {
            _.forEach(newVal, (newEntry) => {
                var oldEntry = _.find(oldVal, (oldEntry) => {
                    return newEntry.slotID === oldEntry.slotID;
                });

                var positionProp = broadcastService.isMixedClassMode(ctrl.selectedCarClass)
                    ? 'position'
                    : 'classPosition';

                if (oldEntry && oldEntry.classPosition !== newEntry.classPosition) {
                    $timeout(function() {
                        var elem = document.querySelector('.extended-battle-box .slot-' + newEntry.slotID);

                        if (!elem) {
                            return;
                        }

                        var moveAmount;
                        if (newEntry[positionProp] < oldEntry[positionProp]) {
                            moveAmount = (oldEntry[positionProp] - newEntry[positionProp]) * 100;
                        } else {
                            moveAmount = ((newEntry[positionProp] - oldEntry[positionProp]) * 100) * -1;
                        }

                        ctrl.animatingPositionChange = true;
                        elem.style.transform = 'translateY(' + moveAmount + '%)';

                        $timeout(() => {
                            elem.style.transition = 'transform 500ms';
                            elem.style.transform = 'translateY(0)';

                            $timeout(function() {
                                elem.style.transition = null;
                                ctrl.animatingPositionChange = false;
                            }, 600)
                        }, 0);
                    })
                }
            });
        }
    }
});
