angular.module('focusIndicator', ['BroadcastService']).component('focusIndicator', {
    bindings: {
        customConfig: '<',
        entry: '<'
    },
    templateUrl: 'src/components/focusindicator/focusindicator.html',
    controller: function(broadcastService) {
        var ctrl = this;

        this.getElemStyle = function() {
            var carClassName = _.get(ctrl, 'entry.carClass');
            var elemBgColor = broadcastService.getCarClassColorFromConfig(ctrl.customConfig, carClassName);
            if (!elemBgColor) {
                elemBgColor = broadcastService.getCustomConfigSeriesColor(ctrl.customConfig);
            }

            return {
                backgroundColor: elemBgColor
            }
        }
    }
});
