angular.module('overlay.onboardDriverBox', []).component('onboardDriverBoxOverlay', {
    bindings: {
        overlayInfo: '<',
        selectedDriver: '<',
        config: '<',
        customConfig: '<',
        sessionInfo: '<',
        standings: '<',
        entryDataField: '<',
        selectedCarClass: '<',
        cars: '<'
    },
    templateUrl: 'src/components/onboarddriverbox/onboarddriverbox.overlay.html',
    controller: function (broadcastService, sessionService, standingsService, utilService) {
        var ctrl = this;
        this.carImageSrc = null;

        this.$onChanges = function(changes) {
            if (changes.selectedDriver) {
                var newName = _.get(changes, 'selectedDriver.currentValue.driverName');
                var oldName = _.get(changes, 'selectedDriver.previousValue.driverName');

                if (newName && newName !== oldName) {
                    broadcastService.getDiskOrGameCarImageSrc(
                        ctrl.selectedDriver,
                        _.get(ctrl, 'config.customConfig'),
                        setCarImageSrc
                    );
                }
            }
        }

        function setCarImageSrc(src) {
            if (src) {
                ctrl.carImageSrc = src;
            }
        }

        this.formatLapTime = function (lapTime) {
            return utilService.secToString(lapTime, 3);
        }

        this.getCssCarClassName = function(carClass) {
            return utilService.generateCssCarClassName(carClass);
        }

        this.getBorderLeftStyle = function() {
            return broadcastService.getDriverBorderStyle(ctrl.selectedDriver, ctrl.customConfig, 'borderLeft');
        }

        this.getSwipeStyle = function() {
            return broadcastService.getCarClassColorStyle(
                ctrl.selectedDriver,
                ctrl.customConfig,
                'backgroundColor'
            );
        }

        this.getClassColor = function() {
            if (!ctrl.selectedDriver) {
                return 'white';
            }

            return broadcastService.getCarClassColorFromConfig(
              ctrl.customConfig,
              ctrl.selectedDriver.carClass,
              'backgroundColor'
            );
        }

        this.getDiffToLeader = function() {
            if (sessionService.isRaceSession(ctrl.sessionInfo)) {
                return this.getGapToLeader();
            } else {
                var timeDiff = standingsService.displayBestLapTimeDiffToLeader(
                    ctrl.selectedDriver,
                    ctrl.standings,
                    !broadcastService.isMixedClassMode(ctrl.selectedCarClass),
                    1
                );

                if (timeDiff === '') {
                    return '-';
                }

                return timeDiff;
            }
        }

        this.getDiffToNext = function() {
            if (sessionService.isRaceSession(ctrl.sessionInfo)) {
                return this.getGapToNext();
            } else {
                var timeDiff = standingsService.displayBestLapTimeDiffToNextDriver(
                    ctrl.selectedDriver,
                    ctrl.standings,
                    !broadcastService.isMixedClassMode(ctrl.selectedCarClass),
                    1
                );

                if (timeDiff === '') {
                    return '-';
                }

                return timeDiff;
            }
        }

        this.getGapToLeader = function() {
            if (!ctrl.selectedDriver || !ctrl.sessionInfo || !ctrl.standings) {
                return '';
            }

            if (sessionService.isRaceSession(ctrl.sessionInfo)) {
                return this.formatGap(
                    standingsService.displayLiveGapToLeader(
                        ctrl.selectedDriver,
                        !broadcastService.isMixedClassMode(ctrl.selectedCarClass),
                        1
                    )
                );
            }

            return this.formatGap(
                standingsService.displayBestLapTimeDiffToLeader(
                    ctrl.selectedDriver,
                    ctrl.standings,
                    !broadcastService.isMixedClassMode(ctrl.selectedCarClass),
                    1
                )
            );
        }

        this.getGapToNext = function() {
            if (!ctrl.selectedDriver || !ctrl.sessionInfo || !ctrl.standings) {
                return '';
            }

            if (sessionService.isRaceSession(ctrl.sessionInfo)) {
                return this.formatGap(
                    standingsService.displayLiveGapToNextDriver(
                        ctrl.selectedDriver,
                        !broadcastService.isMixedClassMode(ctrl.selectedCarClass),
                        1)
                );
            }

            return this.formatGap(
                standingsService.displayBestLapTimeDiffToNextDriver(
                    ctrl.selectedDriver,
                    ctrl.standings,
                    !broadcastService.isMixedClassMode(ctrl.selectedCarClass),
                    1
                )
            );
        }

        this.formatGap = function(gap) {
            if (gap === '' || gap === '-') {
                return '-';
            }

            if (gap.indexOf('-') > -1) {
                return gap.replace('+', '', gap);
            }

            if (gap.indexOf('+') === -1) {
                return '+' + gap;
            }

            return gap;
        }
    }
});
