angular.module('overlay.replayTransition', []).component('replayTransitionOverlay', {
    bindings: {
        overlayInfo: '<',
        overlays: '<',
        customConfig: '<'
    },
    templateUrl: 'src/components/replaytransitionoverlay/replaytransition.overlay.html',
    controller: function (broadcastService, $timeout) {
        var ctrl = this;
        ctrl.transitionVisible = false;
        ctrl.transitionOff = false;

        ctrl.$onChanges = function(changes) {
            if (changes.overlayInfo) {
                var visibleOld = _.get(changes, 'overlayInfo.previousValue.visible');
                var visibleNew = _.get(changes, 'overlayInfo.currentValue.visible');

                if (!visibleOld && visibleNew) {
                    // Replay toggled on
                    ctrl.transitionVisible = true;
                    $timeout(function() {
                        ctrl.transitionVisible = false;
                    }, 5000);
                } else if (!visibleNew && visibleOld) {
                    // Replay toggled off.
                    ctrl.transitionVisible = true;
                    ctrl.transitionOff = true;
                    $timeout(function() {
                        ctrl.transitionVisible = false;
                        ctrl.transitionOff = false;
                    }, 3500);
                }
            }
        }

        this.getSeriesColor = function(getTextColor = false) {
            return broadcastService.getCustomConfigSeriesColor(ctrl.customConfig, getTextColor);
        }
    }
});
