angular.module('resultHeader', []).component('resultHeader', {
    bindings: {
        config: '<',
        customConfig: '<',
        overlayInfo: '<',
        topic: '<',
        schedule: '<?',
        sessionInfo: '<?',
        trackName: '<?'
    },
    templateUrl: 'src/components/resultheader/resultheader.html',
    controller: function(broadcastService, utilService) {
        var ctrl = this;

        this.getCssCarClassName = function() {
            var selectedCarClass = getSelectedCarClass();
            if (!selectedCarClass) {
                return '';
            }

            return utilService.generateCssCarClassName(selectedCarClass);
        }

        this.getHeaderBorderStyle = function() {
            var selectedCarClass = getSelectedCarClass();

            if (selectedCarClass) {
                var borderStyle = broadcastService.getBorderStyle(
                    getSelectedCarClass(),
                    ctrl.customConfig,
                    'borderLeft'
                );

                if (borderStyle) {
                    return borderStyle;
                }
            }

            return {
                borderLeft: 'solid 4px' + broadcastService.getCustomConfigSeriesColor(ctrl.customConfig)
            }
        }

        this.getSeriesName = function() {
            return broadcastService.getCustomConfigSeriesName(ctrl.customConfig);
        }

        this.getTrackName = function() {
            if (ctrl.trackName === '') {
                return null;
            }

            if (ctrl.trackName) {
                return ctrl.trackName;
            }

            return broadcastService.getCurrentTrackNameFromSchedule(ctrl.schedule, ctrl.customConfig, ctrl.sessionInfo);
        }

        function getSelectedCarClass() {
            return _.get(ctrl, 'overlayInfo.settings.selectedCarClass');
        }
    }
});
