angular.module('controlpanel.sessionResultsSettings', ['BroadcastService'])
    .component('sessionResultsSettings', {
    bindings: {
        settings: '<',
        carClasses: '<',
        sessionResults: '<',
        sessionNames: '<',
        showSessionSelection: '<',
        updateSettings: '&'
    },
    templateUrl: 'src/components/sessionresultssettings/sessionresultssettings.html',
    controller: function(broadcastService) {
        var ctrl = this;
        this.selectedCarClass = null;
        this.selectedSession = null;

        this.$onChanges = function(changes) {
            if (changes.settings && changes.settings.currentValue) {
                var update = false;

                if (!this.selectedCarClass) {
                    var selectedCarClass = getSelectedCarClass();

                    if (broadcastService.isMixedClassMode(selectedCarClass)
                        || (selectedCarClass && _.includes(ctrl.carClasses, selectedCarClass))) {
                        ctrl.selectedCarClass = selectedCarClass;
                    } else {
                        ctrl.selectedCarClass = ctrl.carClasses[0];
                    }

                    update = true;
                }

                if (!ctrl.selectedSession) {
                    var selectedSession = _.get(changes, 'settings.currentValue.selectedSession');

                    if (selectedSession) {
                        ctrl.selectedSession = selectedSession;
                        update = true;
                    } else {
                        if (ctrl.sessionNames) {
                            ctrl.selectedSession = ctrl.sessionNames[0];
                            update = true;
                        }
                    }
                }

                if (update) {
                    ctrl.update();
                }
            }
        }

        function getSelectedCarClass() {
            return _.get(ctrl, 'settings.selectedCarClass');
        }

        this.selectPreviousPage = function() {
            var targetPage = ctrl.settings.page - 1;

            if (targetPage > 0) {
                ctrl.settings.page = targetPage;
                ctrl.update();
            }
        }

        this.selectNextPage = function() {
            var targetPage = ctrl.settings.page + 1;

            if (targetPage <= ctrl.getMaxPages()) {
                ctrl.settings.page = targetPage;
                ctrl.update();
            }
        }

        this.isPreviousPageButtonDisabled = function() {
            if (ctrl.getMaxPages() === 0) {
                return true;
            }

            if (ctrl.settings && ctrl.settings.page === 1) {
                return true;
            }

            return false;
        }

        this.isNextPageButtonDisabled = function() {
            if (ctrl.getMaxPages() === 0) {
                return true;
            }

            if (ctrl.settings && ctrl.settings.page === ctrl.getMaxPages()) {
                return true;
            }

            return false;
        }

        this.getEntries = function(carClass) {
            if (carClass) {
                return _.filter(ctrl.sessionResults, { carClass: carClass });
            }

            return ctrl.sessionResults;
        }

        this.getDriverCount = function(carClass) {
            var entries = ctrl.getEntries(carClass);
            if (!entries) {
                return 0;
            }

            return entries.length;
        }

        this.getMaxPages = function() {
            var driverCount;
            if (broadcastService.isMixedClassMode(getSelectedCarClass())) {
                driverCount = ctrl.getDriverCount(null);
            } else {
                driverCount = ctrl.getDriverCount(ctrl.selectedCarClass);
            }

            var driversPerPage = _.get(ctrl, 'settings.driversPerPage');
            if (driverCount === undefined || driversPerPage === undefined) {
                return 0;
            }

            return Math.ceil(driverCount / driversPerPage);
        }

        this.onSelectedCarClassChanged = function() {
            ctrl.settings.page = 1;
            this.update();
        }

        this.onSelectedSessionChanged = function() {
            ctrl.settings.page = 1;
            this.update();
        }

        this.update = function () {
            if (!ctrl.settings) {
                return;
            }

            ctrl.settings.selectedCarClass = ctrl.selectedCarClass;
            ctrl.settings.selectedSession = ctrl.selectedSession;

            ctrl.updateSettings({ settings: ctrl.settings });
        }
    }
});
