angular.module('overlay.videoSlide', []).component('videoSlideOverlay', {
    bindings: {
        overlayInfo: '<',
        config: '<',
        customConfig: '<',
    },
    templateUrl: 'src/components/videoslideoverlay/videoslide.overlay.html',
    controller: function($animate, $scope, $timeout, broadcastService) {
        var ctrl = this;
        ctrl.videos = [];
        ctrl.currentVideoSrc = null;
        var overlayElem = document.querySelector('.video-slide-overlay');
        var videoElem = overlayElem.querySelector('.video');
        var currentVideoIndex = null;
        var videoBaseUrl;
        var startedVideoSlide = false;

        this.$onChanges = function(changes) {
            if (changes.config) {
                var customConfigName = _.get(changes, 'config.currentValue.customConfig');

                if (!customConfigName) {
                    return;
                }

                videoBaseUrl = 'customize/' + customConfigName + '/videos/';
            }

            if (changes.customConfig) {
                if (!ctrl.videos || ctrl.videos.length === 0) {
                    ctrl.videos = _.get(changes, 'customConfig.currentValue.overlays.videoSlide.videos');
                }
            }

            if (changes.overlayInfo) {
                var visible = _.get(changes, 'overlayInfo.currentValue.visible');

                if (visible && !startedVideoSlide) {
                    if (ctrl.videos && ctrl.videos.length > 0) {
                        startVideoSlide();
                    }
                }
            }
        };

        function startVideoSlide() {
            startedVideoSlide = true;
            videoElem.addEventListener('ended', onVideoEnded);
            currentVideoIndex = 0;
            playVideo();
        }

        function onVideoEnded() {
            if (hasNextVideo()) {
                playNextVideo();
            } else {
                $scope.$emit('VIDEO_SLIDE:LAST_VIDEO_ENDED');
            }
        }

        function playNextVideo() {
            currentVideoIndex++;
            $animate.addClass(videoElem, 'play-next-video');
        }

        function hasNextVideo() {
            return ctrl.videos
                && currentVideoIndex < ctrl.videos.length - 1
                && ctrl.videos[currentVideoIndex + 1];
        }

        $animate.on('addClass', overlayElem, function(element, phase) {
            if (phase === 'close') {
                $animate.removeClass(videoElem, 'play-next-video');
                playVideo();
            }
        });

        function playVideo() {
            var video = _.get(ctrl, 'videos.' + currentVideoIndex);

            if (!video) {
                return;
            }

            ctrl.currentVideoSrc = videoBaseUrl + video;

            $timeout(function() {
                videoElem.load();
                videoElem.play().catch(function() {
                    videoElem.muted = true;
                    videoElem.play();
                });
            });
        }

        this.getOverlayStyle = function() {
            var seriesColor = broadcastService.getCustomConfigSeriesColor(ctrl.customConfig);

            if (!seriesColor) {
                return null;
            }

            return '--video-slide-background-color: ' + seriesColor;
        }
    }
});
