angular.module('UtilService', []).service('utilService', function () {
    var service = {
        secToString: secToString,
        getCustomColor: getCustomColor,
        validateHexColor: validateHexColor,
        hexToRgb: hexToRgb,
        hexToHSL: hexToHSL,
        generateCssCarClassName: generateCssCarClassName
    }

    return service;

    function secToString (value, n = 0) {
        if (value <= 0) {
            return '-';
        }

        var pad = (n, width, z = '0') => {
            z = z || '0';
            n = n + '';
            return n.length >= width ? n : new Array(width - n.length + 1).join(z) + n;
        }

        var hours = Math.floor(value / 3600);
        var minutes = Math.floor((value - hours * 3600) / 60);
        var seconds = value - hours * 3600 - minutes * 60;
        var time = '';
        if (hours != 0) {
            time += hours + ":";
            time += pad(minutes, 2) + ":";
        } else {
            time += minutes != 0 ? minutes + ":" : "";
        }
        time += value > 60 ? pad(seconds.toString().split(".")[0], 2) : seconds.toString().split(".")[0];
        if (n > 0) {
            n = n > 3 ? 3 : n;
            var ms;
            var roundedSeconds = _.round(seconds, 3).toString();

            if (roundedSeconds.indexOf('.') != -1) {
                ms = roundedSeconds.split(".")[1].slice(0, n);
                if (ms.length < n) {
                    var addCount = n - ms.length;
                    for (var i = 0; i < addCount; i++) {
                        ms += "0";
                    }
                }
            } else {
                ms = pad(0, n);
            }

            time += "." + ms;
        }
        time = time == '0' ? "-" : time;
        time = time === '1:0' ? '1:00' : time;
        return time;
	}

    function getCustomColor(element, property, customConfig) {
        if (!customConfig || !customConfig.colors || !customConfig.colors[element]) {
            return null;
        }

        var propertyValue = customConfig.colors[element][property];

        if (propertyValue && validateHexColor(propertyValue)) {
            return propertyValue;
        }

        return null;
    }

    function validateHexColor(hexColor) {
        return /^#([0-9A-F]{3}){1,2}$/i.test(hexColor);
    }

    function hexToRgb(hex) {
        var shorthandRegex = /^#?([a-f\d])([a-f\d])([a-f\d])$/i;
        hex = hex.replace(shorthandRegex, function(m, r, g, b) {
            return r + r + g + g + b + b;
        });

        var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex);

        if (result) {
            return {
                r: parseInt(result[1], 16),
                g: parseInt(result[2], 16),
                b: parseInt(result[3], 16)
            };
        } else {
            return {
                r: null,
                g: null,
                b: null
            };
        }
    }

    function hexToHSL(hex) {
        let { r, g, b } = hexToRgb(hex);

        if (r == null || g == null || b == null) {
            return {
                h: null,
                s: null,
                l: null
            }
        }

        // Convert RGB to HSL.
        r /= 255;
        g /= 255;
        b /= 255;
        let cmin = Math.min(r,g,b),
            cmax = Math.max(r,g,b),
            delta = cmax - cmin,
            h = 0,
            s = 0,
            l = 0;

        if (delta === 0) {
            h = 0;
        } else if (cmax === r) {
            h = ((g - b) / delta) % 6;
        } else if (cmax === g) {
            h = (b - r) / delta + 2;
        } else {
            h = (r - g) / delta + 4;
        }

        h = Math.round(h * 60);

        if (h < 0) {
            h += 360;
        }

        l = (cmax + cmin) / 2;
        s = delta === 0 ? 0 : delta / (1 - Math.abs(2 * l - 1));
        s = +(s * 100).toFixed(1);
        l = +(l * 100).toFixed(1);

        return {
            h: h,
            s: s,
            l: l
        };
    }

    function generateCssCarClassName(carClass) {
        if (typeof carClass !== 'string') {
            return '';
        }

        return carClass.replace(/[ .]/g, '-') + '-class';
    }
});
