/**
 * @template T
 * @typedef {Object} HttpPromiseResponse
 * @property {T} data
 * @property {number} status
 * @property {function} headers
 * @property {Object} config
 * @property {string} statusText
 * @property {string} xhrStatus
 */

/**
 * @typedef {'FSTAT_NONE' | 'FSTAT_FINISHED' | 'FSTAT_DNF' | 'FSTAT_DQ' | 'FSTAT_MAXIMUM'} FinishStatus
 */

/**
 * @typedef {'BEFORE' | 'RECONNAISSANCE' | 'WALKTHROUGH' | 'FORMATION' | 'COUNTDOWN' | 'GREEN' | 'SAFETY_CAR' | 'RED' | 'CHECKERED' | 'INVALID'} GamePhase
 */

/**
 * @typedef {'NONE' | 'REQUEST' | 'ENTERING' | 'SETUP' | 'STOPPED' | 'EXITING'} PitState
 */

/**
 * @typedef {Object} Driver
 * @property {Object} attackMode
 * @property {number} bestLapSectorTime1
 * @property {number} bestLapSectorTime2
 * @property {number} bestLapTime
 * @property {number} bestSectorTime1
 * @property {number} bestSectorTime2
 * @property {Object} carAcceleration
 * @property {string} carClass
 * @property {string} carId
 * @property {string} carNumber
 * @property {Object} carPosition
 * @property {Object} carVelocity
 * @property {number} currentSectorTime1
 * @property {number} currentSectorTime2
 * @property {string} driverName
 * @property {boolean} drsActive
 * @property {number} estimatedLapTime
 * @property {FinishStatus} finishStatus
 * @property {boolean} focus
 * @property {number} fuelFraction
 * @property {string} fullTeamName
 * @property {GamePhase} gamePhase
 * @property {boolean} hasFocus
 * @property {boolean} headlights
 * @property {number} inControl
 * @property {boolean} inGarageStall
 * @property {number} lapDistance
 * @property {number} lapsBehindLeader
 * @property {number} lapsBehindNext
 * @property {number} lapsCompleted
 * @property {number} lapStartET
 * @property {number} lastLapTime
 * @property {number} lastSectorTime1
 * @property {number} lastSectorTime2
 * @property {number} pathLateral
 * @property {number} penalties
 * @property {string} pitGroup
 * @property {number} pitLapDistance
 * @property {PitState} pitState
 * @property {number} pitstops
 * @property {boolean} pitting
 * @property {boolean} player
 * @property {number} position
 * @property {number} qualification
 * @property {string} sector
 * @property {boolean} serverScored
 * @property {number} slotID
 * @property {number} steamID
 * @property {number} timeBehindLeader
 * @property {number} timeBehindNext
 * @property {number} timeIntoLap
 * @property {number} trackEdge
 * @property {boolean} underYellow
 * @property {string} upgradePack
 * @property {string} vehicleFilename
 * @property {string} vehicleName
 */

/**
 * @typedef {('Pit in'|'Box'|'Pit out'|'Out lap'|null)} DetailedPitState
 */

/**
 * @typedef {Object} DetailedPitStateMapValue
 * @property {Driver} driver
 * @property {DetailedPitState} detailedPitState
 */

/**
 * @typedef {Map<Number, DetailedPitStateMapValue>} DetailedPitStateMap
 */

/**
 * @typedef {Object} SessionInfo
 * @property {number} ambientTemp
 * @property {number} averagePathWetness
 * @property {number} currentEventTime
 * @property {number} darkCloud
 * @property {number} endEventTime
 * @property {string} gameMode
 * @property {number} gamePhase
 * @property {boolean} inRealtime
 * @property {number} lapDistance
 * @property {number} maximumLaps
 * @property {number} maxPathWetness
 * @property {number} maxPlayers
 * @property {number} minPathWetness
 * @property {number} numberOfVehicles
 * @property {number} numRedLights
 * @property {boolean} passwordProtected
 * @property {string} playerFileName
 * @property {string} playerName
 * @property {Object} raceCompletion
 * @property {number} raining
 * @property {string} serverName
 * @property {number} serverPort
 * @property {string} session
 * @property {number} startEventTime
 * @property {number} startLightFrame
 * @property {string} trackName
 * @property {number} trackTemp
 * @property {Object} windSpeed
 * @property {Array<string>} yellowFlagState
 */

export {};
