# Graphics
rFactor 2 aims to deliver the most physically accurate racing simulator on the market. We focus more on how the car behaves and interacts with its physical environment than on how impressive the scenery is rendered in every level of detail. This means the level of display customisation we allow is not as high as what you find in some other platforms.

Nevertheless, this screen gives you quite a bit of choice in how detailed and realistic you want the image on your screen to be. You may want to experiment with this settings to find the balance between realism and performance that works best for you.

Changing any of the settings in the 'Display' column will require you to restart the game to see them in action.

Note: some settings will not be available during an event.

## Display

### Video Driver
This setting lets you choose which monitor rFactor 2 will be displayed on when in full-screen mode.

### Window Mode
This setting determines how rFactor 2 will be displayed on screen:

**Windowed**

In this mode rFactor 2 runs in a standard window, managed by the Windows operating system. It will have the standard menus, bars and controls.

**Borderless**

In this mode rFactor 2 runs in window on screen, but with all the standard window elements such as menus, bars and controls remove. This window is still managed by your Windows OS but when set to your monitor's resolution, it will look like it is running fullscreen. The difference is that in Borderless mode you still have access to the Windows pop-up menu and bar by pressing the Window key. This can be useful when you have single monitor setup and occasionally need to access other programs running on your PC while playing rFactor 2.

**Fullscreen**

In fullscreen mode rFactor 2 takes full control of the entire screen. In a single monitor setup you cannot access any of the normal Windows functions in this mode. In theory, fullscreen mode should give the best performance but this may not always be the case, so it pays to compare borderless mode with fullscreen mode to see what works best for you.

### Resolution
This setting determines the resolution used to render the rFactor 2 window or screen.

### Refresh Rate
Change the refresh rate of your display.

### Vertical Sync
This setting (also known as V-Sync) determines how often a new image is written to your display. You can change this setting when you experience 'tearing' of the image on your screen. This happens when a new image gets written out before the previous image has been completely rendered on screen. This can cause a visible mismatch between the top and bottom parts of your screen, referred to as 'tearing'. Adjusting this setting can prevent this from happening but it may negatively affect rFactor 2's display frame rate.

**Off**

When V-Sync is turned off, a new image is written to your display as soon as a new image is available in memory.

**Software**

When set to 'Software', a software timer is used to time the rendering of a new image on screen.

**Video**

When set to 'Video', the hardware video driver in DirectX determines how often a new image is rendered to your screen.

### Post Effects
The graphics produced by rFactor 2 are pretty awesome as they are. But modern GPU's come with a lot of clever tricks to make awesome graphics look even better. The Post Effects setting gives you control over the number of these 'tricks' that will be applied and the resolution and fidelity with which they will be rendered. The reason you may not always want to just go for the highest ('Ultra') settings is one of realism versus responsiveness. Ultra-realistic graphics processing requires a lot of computing power. That may become too much for your PC and negatively affect your frame rate or even overload your PC. Experimenting with the 'Post Effects' settings is the best way to experience this trade-off for yourself. You may want to use different settings for different situations, for instance a lower setting for racing - for speed and consistency of frame rates - and a higher settings for taking screenshots or recording your races - to get the most realistic images possible.

**None**

This setting applies the very minimum of post-processing, in the form of tone mapping to get a dynamic colour range best suited for your monitor.

**Low**

This setting gives you tone mapping, auto-exposure, colour correction and glare effects.

**Medium**

This setting adds light shafts (such as the light coming from the sun through the clouds) and depth-of field effects in trackside cameras.

**High**

This setting uses the same effects as 'Medium' but increases the fidelity with which these effects are rendered.

**Ultra**

This settings renders the effects at a higher resolution, most suited for very realistic-looking screenshots or broadcasts. As a mnemonic, think 'Screenshot Mode' wherever you see 'Ultra' in the Graphics and Display settings.

### Motion blur
This setting controls if motion blur should be applied to the game and whether it should be applied to all cameras or just the trackside cameras.

### FSAA
This setting determines the level of full screen anti-aliasing applied to the image on screen. This in turn determines the smoothness of the edges and lines you see in the image. Higher levels of anti-aliasing mean a higher workload for your PC, so this setting is often a compromise between the best possible image and an acceptable burden on your PC.

**Off**

This means no anti-aliasing is applied.

**MSAA 2x/MSAA 4x/MSAA 8x**

MSAA stands for Multi-Sample Anti-Aliasing. Each consecutive setting doubles the number of samplings being applied to each pixel.

### Multiview
This setting is used to enable a multi-monitor setup.

### FXAA
This setting provides an additional level of anti-aliasing. It is less precise than FSAA but less computationally expensive.

## Graphics

### Preset
This setting lets you quickly change between different levels of graphics fidelity.

### Circuit Detail
This setting affects the static geometry of the track and determines which elements are included when rendering to the screen. The lower settings leave out secondary objects such as fans at the side of the road, trees and fences. The higher settings add more objects to render and increases the fidelity with which they are rendered. Obviously, the higher the setting the more work your PC needs to do to calculate and render all those details.

### Player detail
This setting determines which elements in the player's field of visions are actually rendered on screen.

### Opponent detail
This setting determines the level of detail with which your opponents' cars are being rendered on screen.

### Texture detail
This setting determines the level of detail with which textures are rendered.

### Texture filter
This setting lets you choose between different methods to render textures realistically at different distances and perspectives.

### Special effects
This setting determines the amount of additional effects such as smoke, spray and clouds are added in addition to the standard elements of a scene. This includes rendering moving images on monitors and screens visible in the scene.

### Shadows
This setting determines whether shadows are being rendered and with which quality. When set to 'Off', only a simple blurring algorithm will be used. The higher levels apply multiple passes to refine the edges and transitions of the shadows rendered.

### Shadow blur
A higher setting makes shadows appear smoother.

### Soft particles
This setting determines how interactions between soft elements like clouds of dust the track are being rendered.

### Rain drops
This setting determines the level of realism and detail with which rain is being rendered on the track, the vehicle and the windshield. When set to 'Off' you just see rain falling from the sky. In the other settings you see rain splashing on the track, rain forming puddles, ripples on the surface of those puddles, rain splashing on your car and your windshield, and active interaction between the raindrops on your windshield and the windshield wipers. The higher the level you set this setting to, the more particles get rendered and the higher the resolution they are rendered with.

### Road reflection
This setting determines the level of detail of the reflections showing in wet surfaces on the track. When set to 'Off', only basic reflections are rendered. The higher the level, the more sophisticated the reflections will be, both in level of detail and resolution, and in the methods used to calculate their appearance.

### Environment reflection
This setting determines how elements on and around the track are reflected on shiny surfaces. When set to 'Off', only certain pre-defined elements are rendered as reflections. The other settings turn on more dynamic reflections at an increasingly higher resolution and higher refresh rates.

### Stabilize Horizon
This setting can be used with VR-headsets and screens alike to help match the position of the horizon with the position of your head in relation to your neck and shoulder. This can mitigate nausea when the visible horizon tilts (for instance when your car is banking) but your physical body doesn't actually move. Low and medium settings filter sudden pitch movements, while high and ultra settings additionally filter roll movement.

### Showroom
In the showroom you can view your car, paint it and select upgrades. This setting toggles between different styles of showroom.

## Visuals

### Visible vehicles
This setting determines the number of cars you see around you on the track. Unless you experience performance issues you should probably keep this at 50 or more.

### Live TV Displays
This setting effects the Live TV Displays around some tracks. You can turn them on or off, as well as only have them on from external broadcast cameras.

### Message center
This setting turns the on-screen message center on or off.

### Kph / Mph
This setting sets the displayed unit of speed to Kph or Mph.

### Units
This setting lets you choose between metric or imperial units of measurement.

### Battery units
This setting will switch between percentage and kW/kWh units for displaying car battery information.

### HUD enabled
This setting switches the HUD display on or off.

### HUD selection
This setting lets you choose between different types of HUD display.

### Default view
While you drive you can cycle through various different views. This setting determines the view you start with when driving.

### Mirrors
This setting turns your car's mirrors on or off. Rendering mirrors require quite a bit of computer power. Turning them on may have a negative effect on your system's performance. When tuning your settings for performance, you want to consider turning the mirrors off.

### Steering wheel
This setting lets you decide whether rFactor 2 displays a steering wheel on screen or not.

### Vertical FOV
This setting determines the vertical field of vision. It determines how much of the vertical arc from ground to sky you see on screen. Since everything has to be rendered at the correct aspect ratio, changing the value of the vertical FOV will also affect the horizontal field of vision.

### Download custom skins
Turning this on allows downloading custom skins of other players on a multiplayer server.

### Wait for all plugins to load
Turning this on will delay race starts in singleplayer until all plugins have loaded.

### Low speed info screen position
Changes the position of the display showing you information about whether pits are closed, which car to follow under full-course yellow, and so on.

### TLI screen vertical position
Changes the vertical position of the Track Limits Info screen, which shows you warnings about exceeding track limits.

### TLI screen horizontal position
Changes the horizontal position of the Track Limits Info screen, which shows you warnings about exceeding track limits.
